<?php
/**
 * Created by PhpStorm.
 * User: kevin
 * Email: robisignals@gmail.com
 * Date: 15/02/2020
 * Time: 20:18
 */

namespace App\Http\Requests;

class ResetPasswordRequest extends BaseRequest
{

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {

        $rules = [];

        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
                {
                    return [];
                    break;
                }
            case 'POST':
                {
                    $rules = [
                        'email'         => 'email|required',
                        'token'         => 'required',
                        'password'      => 'required|min:3|confirmed',
                        'password_confirmation' => 'required_with:password'
                    ];
                    break;
                }
            case 'PUT':
            case 'PATCH':
                {
                    $rules = [
                    ];
                    break;
                }
            default:
                break;
        }

        return $rules;

    }
}